<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "proxy".
 *
 * @property int $id
 * @property string|null $domain
 * @property string|null $ip
 * @property int|null $status80
 * @property int|null $status443
 * @property string|null $updated_at
 * @property string|null $destination
 */
class Proxy extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'proxy';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['domain', 'ip', 'destination', 'ipxor', 'comment'], 'string'],
            [['status80', 'status443'], 'default', 'value' => null],
            [['status80', 'status443', 'pings', 'dnsbl'], 'integer'],
            [['updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'domain' => 'Domain',
            'ip' => 'Ip',
            'ipxor' => "Ip'",
            'status80' => 'Status80',
            'status443' => 'Status443',
            'updated_at' => 'Updated At',
            'destination' => 'Destination',
            'comment' => 'Comment',
            'pings' => 'Pings',
        ];
    }
}
